import processing.core.*; import controlP5.*; import sojamo.drop.*; import oscP5.*; import netP5.*; import java.applet.*; import java.awt.*; import java.awt.image.*; import java.awt.event.*; import java.io.*; import java.net.*; import java.text.*; import java.util.*; import java.util.zip.*; import javax.sound.midi.*; import javax.sound.midi.spi.*; import javax.sound.sampled.*; import javax.sound.sampled.spi.*; import java.util.regex.*; import javax.xml.parsers.*; import javax.xml.transform.*; import javax.xml.transform.dom.*; import javax.xml.transform.sax.*; import javax.xml.transform.stream.*; import org.xml.sax.*; import org.xml.sax.ext.*; import org.xml.sax.helpers.*; public class LSDJ_Wav_Editor_2 extends PApplet {





float fLastTime;

int g_iDataPerByte = 2;
int g_iWavStart = unhex("6000");
int g_iMaxNumInstruments = 8;
int g_iFrameLength = 32;
int g_iNumFrames = 16;
int g_iInstrumentByteLength = 256;
int g_iFrameByteLength = 16;

int g_iMainDrawX = 20;
int g_iMainDrawY = 20;
int g_iMainDrawPixelSize = 10;
Point2D g_MainFrameDrawSize;

SDrop g_Dropper;
ControlP5 g_ControlP5;

SelectionInfo g_SelectionInfo;
DataManager g_DataManager;
WavEditor g_WavEditor;

Frame g_FrameClipboard = new Frame();

Frame g_SawFrame = new Frame();
Frame g_SquareFrame = new Frame();


public void setup()
{
  
  size (600, 320);
  smooth();

  g_Dropper = new SDrop(this);
  g_ControlP5 = new ControlP5(this);
   
  initialiseGUI();

  fLastTime = millis();

  g_SelectionInfo = new SelectionInfo();
  g_DataManager = new DataManager();
  g_WavEditor = new WavEditor();
  
  generateFrames();

  //g_DataManager.loadData("lsdj.sav");

}




public void draw()
{

  background(200);
  
  g_WavEditor.processMainFrame(g_SelectionInfo);

  processFrameSelection();
  
  displayClipboard();

  if (millis() > (fLastTime + 33))
  {
    fLastTime = millis();
    //process
  }

}



public void mousePressed()
{

  g_bMouseDown = true;

}

public void mouseReleased()
{

  g_bMouseDown = false;

}

public boolean mouseDown()
{
  return g_bMouseDown;
}



public void dropEvent(DropEvent theDropEvent) {
  if(theDropEvent.isFile()) {
    // for further information see
    // http://java.sun.com/j2se/1.4.2/docs/api/java/io/File.html
    File myFile = theDropEvent.file();
    println("\nisDirectory ? "+myFile.isDirectory()+"  /  isFile ? "+myFile.isFile());

    println(myFile.toString());

    g_SelectionInfo.setInstrument(0);
    g_SelectionInfo.setFrame(0);

    g_DataManager.loadData(myFile.toString());
  }
}


public void keyPressed()
{

  int iFrame = g_SelectionInfo.getFrame();

  if (key == CODED)
  {
    if (keyCode == RIGHT)
    {
      iFrame++;

    }
    else if (keyCode == LEFT)
    {
      iFrame--;
    }
  }

  if (iFrame < 0) iFrame = g_iNumFrames-1;
  if (iFrame > g_iNumFrames-1) iFrame = 0;
  
  g_SelectionInfo.setFrame(iFrame);

}


class Frame
{

  int iData[];

  Frame()
  {
    iData = new int [g_iFrameLength];
  }
  
  public Frame getCopy()
  {
  
    Frame f = new Frame();
    
    for (int i=0; i<g_iFrameLength; i++)
    {
      f.iData[i] = iData[i];
    }
    
    return f;
    
  }
  
  public int getData(int i)
  {
    return iData[i];
  }

}


class Instrument
{

  Frame frames[];

  Instrument()
  {
    frames = new Frame[g_iNumFrames];
  }

}


class SelectionInfo
{
  
  int m_iSelectedFrame = 0;
  int m_iSelectedInstrument = 0;
  
  public void setFrame(int i) { m_iSelectedFrame = i; }
  public void setInstrument(int i) { m_iSelectedInstrument = i; }
  
  public int getFrame() { return m_iSelectedFrame; }
  public int getInstrument() { return m_iSelectedInstrument; }
  
}


class DataManager
{

  Instrument m_Instruments [] = new Instrument [g_iMaxNumInstruments];
  byte m_LoadedBytes[];
  boolean m_bLoadedData = false;

  DataManager()
  {
    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      m_Instruments[iInstrument] = new Instrument();
      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      {     
        m_Instruments[iInstrument].frames[iFrame] = new Frame();
      }
    }
  }

  public void loadData(String sFile)
  {

    // open a file and read its binary data 
    m_LoadedBytes = loadBytes(sFile); 

    m_bLoadedData = true;

    fillFrames();

  }


  public void debugCheck()
  {
    fillBytesFromFrames();
    fillFrames();
  }


  public void fillFrames()
  {

    int iCurrentLocation = 0;

    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      
      int iInstrumentStart = g_iWavStart + (iInstrument * g_iInstrumentByteLength);

      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      { 

        int iFrameStart = iInstrumentStart + (iFrame * g_iFrameByteLength);

        // two values for each location! nibbles! 
        for (int i = 0; i < g_iFrameLength; i++)
        {

          iCurrentLocation = iFrameStart + floor(i/2);

          int iByteValue = m_LoadedBytes[iCurrentLocation];
          String sBinaryByte = binary(iByteValue, 8);

          String sNibble;

          if (i%2 == 0)
          {
            sNibble = sBinaryByte.substring(0, 4);
          }
          else
          {
            sNibble = sBinaryByte.substring(4);
          }

          m_Instruments[iInstrument].frames[iFrame].iData[i] = unbinary(sNibble);

        } 
      }
    }
  }


  public void fillBytesFromFrames()
  {
    for (int iInstrument = 0; iInstrument < g_iMaxNumInstruments; iInstrument++)
    {
      
      int iInstrumentStart = g_iWavStart + (iInstrument * g_iInstrumentByteLength);

      for (int iFrame = 0; iFrame < g_iNumFrames; iFrame++)
      { 

        int iFrameStart = iInstrumentStart + (iFrame * g_iFrameByteLength); 

        // two values for each location! nibbles! 
        for (int i = 0; i < g_iFrameLength/2; i++)
        {

          int iCurrentLocation = iFrameStart + (g_iInstrumentByteLength*iInstrument) + i;

          String sFirstNibble = binary(m_Instruments[iInstrument].frames[iFrame].iData[2*i], 4);
          String sSecondNibble = binary(m_Instruments[iInstrument].frames[iFrame].iData[(2*i)+1], 4);

          print(sFirstNibble + " " + sSecondNibble);
          println();

          String sByte = sFirstNibble + sSecondNibble;

          int iByteValue = unbinary(sByte);

          m_LoadedBytes[iCurrentLocation] = PApplet.parseByte(iByteValue);

        } 

      }

    }
  }


  public void saveData(String sFile)
  {

    fillBytesFromFrames();

    saveBytes(sFile, m_LoadedBytes);

  }


  public int getData(SelectionInfo info, int pos)
  {  
    return getData(info.getInstrument(), info.getFrame(), pos);
  }
  
  public int getData(int iInstrument, int iFrame, int pos)
  {
    return m_Instruments[iInstrument].frames[iFrame].iData[pos];
  }
  
  public Frame getFrame(int iInstrument, int iFrame)
  {
    return m_Instruments[iInstrument].frames[iFrame];
  }
  
  public Frame getFrame(SelectionInfo info)
  {
    return m_Instruments[info.getInstrument()].frames[info.getFrame()];
  }
  
  public void setFrame(SelectionInfo info, Frame f)
  {
    m_Instruments[info.getInstrument()].frames[info.getFrame()] = f;
  }
  
  
  public void setData(SelectionInfo info, int pos, int data)
  {    
    m_Instruments[info.getInstrument()].frames[info.getFrame()].iData[pos] = data;    
  }
  
  public boolean loadedData()
  {
    return m_bLoadedData;
  }
  
  public void nextInstrument()
  {
    int iInstrument = g_SelectionInfo.getInstrument();
    
    iInstrument++;
    
    if (iInstrument > g_iMaxNumInstruments-1) iInstrument = 0;
    
    g_SelectionInfo.setInstrument(iInstrument);
  }

  public void previousInstrument()
  {
    int iInstrument = g_SelectionInfo.getInstrument();
    
    iInstrument--;
    
    if (iInstrument < 0) iInstrument = g_iMaxNumInstruments-1;
    
    g_SelectionInfo.setInstrument(iInstrument);
  }

}

Textarea g_InstrumentLabel;


public boolean pointInBox(int px, int py, int x, int y, int w, int h)
{

  if ((px>x)&&(px<x+w)&&(py>y)&&(py<y+h))
  {
    return true;
  }
  else
  {
    return false;
  }

}


public void processFrameSelection()
{


  for (int i=0; i<g_iNumFrames/2; i++)
  {
    int iPixelSize = 2;
    int iDrawX = 20 + i * (iPixelSize * (g_iFrameLength + iPixelSize));

    int iFrame;
    Point2D frameSize;
    
    iFrame = i;
    frameSize = g_WavEditor.drawFrame(iFrame, iDrawX, 200, iPixelSize);
    if (iFrame == g_SelectionInfo.getFrame())
    {    
      noFill();
      stroke(53, 53, 243);
      rect(iDrawX-1, 200-1, frameSize.x+2, frameSize.y+2);
    }
    
    iFrame = i+g_iNumFrames/2;
    frameSize = g_WavEditor.drawFrame(iFrame, iDrawX, 240, iPixelSize);
    if (iFrame == g_SelectionInfo.getFrame())
    {    
      noFill();
      stroke(53, 53, 243);
      rect(iDrawX-1, 240-1, frameSize.x+2, frameSize.y+2);
    }
  }

  if (mouseDown())
  {

    for (int i=0; i<g_iNumFrames/2; i++)
    {
      int iPixelSize = 2;
      int iDrawX = 20 + i * (iPixelSize * (g_iFrameLength + iPixelSize));

      Point2D frameSize = g_WavEditor.getFrameSize(iPixelSize);

      if (pointInBox(mouseX,mouseY,iDrawX,200,frameSize.x,frameSize.y))
      {
        g_SelectionInfo.setFrame(i);
      }
      if (pointInBox(mouseX,mouseY,iDrawX,240,frameSize.x,frameSize.y))
      {
        g_SelectionInfo.setFrame( i+g_iNumFrames/2 );
      }
    } 
  } 

}



public void displayClipboard()
{
  g_WavEditor.drawFrame(g_FrameClipboard, 430, 20, 4);
}



public void initialiseGUI()
{

  g_ControlP5.addButton("Save",1,20,290,50,20).setId(0);
  
  g_ControlP5.addButton("Copy Frame",1,80,290,80,20).setId(1);

  g_ControlP5.addButton("Paste Frame",1,170,290,80,20).setId(2);
  
  g_ControlP5.addTextarea("clipboardlabel", "Frame Clipboard:", 350,20,200,60);
  
  g_ControlP5.addButton("Copy Square",1,350,100,80,20).setId(3);
  g_ControlP5.addButton("Copy Saw",1,440,100,80,20).setId(4);
  
  g_ControlP5.addSlider("Pulse Width",0,100,50,350,130,100,10);
  
  g_ControlP5.addButton("Generate Pulse",1,350,150,80,20).setId(5);
  
  g_InstrumentLabel = g_ControlP5.addTextarea("instrumentlabel", "Current Instrument: 0", 260,293,200,60);
  
  g_ControlP5.addButton(" <",1,530,290,20,20).setId(6);
  g_ControlP5.addButton(" >",1,555,290,20,20).setId(7);

}



public void controlEvent(ControlEvent theEvent) 
{
  //println(theEvent.controller().id());

  if (!g_DataManager.loadedData()) return;

  switch(theEvent.controller().id())
  {
  case 0:
    // save
    g_DataManager.saveData("save.sav");
    break;
  case 1:
    // copy frame
    g_FrameClipboard = g_DataManager.getFrame(g_SelectionInfo).getCopy();
    break;
  case 2:
    // paste frame
    g_DataManager.setFrame(g_SelectionInfo, g_FrameClipboard);
    break;
  case 3:
    // copy square
    g_FrameClipboard = g_SquareFrame.getCopy();
    break;
  case 4:
    // copy saw
    g_FrameClipboard = g_SawFrame.getCopy();
    break;
  case 5:
    // generate pulse
    g_DataManager.setFrame(g_SelectionInfo, generatePulseWidth(floor(g_ControlP5.controller("Pulse Width").value())));
    break;
  case 6:
    // previous instrument
    g_DataManager.previousInstrument();
    g_InstrumentLabel.setText("Current Instrument: " + g_SelectionInfo.getInstrument());
    break;
  case 7:
    // next instrument
    g_DataManager.nextInstrument();
    g_InstrumentLabel.setText("Current Instrument: " + g_SelectionInfo.getInstrument());
    break;
  default:
    break;
  }
}


boolean g_bMouseDown = false;

class Point2D {
  int x;
  int y;

  Point2D()
  {
    x = 0;
    y = 0;
  }

  Point2D(int x1, int y1)
  {
    x = x1;
    y = y1;
  }


}


class WavEditor
{

  Point2D m_MainDrawPos;
  int m_iMainPixelSize;
  Point2D m_MainFrameDrawSize;

  WavEditor()
  {
    m_MainDrawPos = new Point2D(20, 20);
    m_iMainPixelSize = 10;
  }

  public void processMainFrame(SelectionInfo selected)
  { 

    if (g_DataManager.loadedData())
    {   
      m_MainFrameDrawSize = drawFrame(selected.getFrame(), m_MainDrawPos.x, m_MainDrawPos.y, m_iMainPixelSize);
      modifyMainFrame(); 
    }
    else
    {
      Point2D frameSize = getFrameSize(m_iMainPixelSize);
      fill(53);
      stroke(153);
      rect(m_MainDrawPos.x, m_MainDrawPos.y, frameSize.x, frameSize.y);      
    }  
  }



  public void modifyMainFrame()
  {

    if (!mouseDown()) return;

    boolean bInGrid = false;

    int iLocalMouseX = mouseX - m_MainDrawPos.x;
    int iLocalMouseY = mouseY - m_MainDrawPos.y;

    if ((iLocalMouseX > 0) && (iLocalMouseX < m_MainFrameDrawSize.x))
    {
      if ((iLocalMouseY > 0) && (iLocalMouseY < m_MainFrameDrawSize.y))
      {
        bInGrid = true;
      }
    }

    if (bInGrid)
    {
      Point2D p = getPointInGrid(iLocalMouseX, iLocalMouseY, 10);

      g_DataManager.setData(g_SelectionInfo, p.x, 16-p.y);
    }


  }


  public Point2D getFrameSize(int iPixelSize)
  {
    Point2D frameSize = new Point2D();

    frameSize.x = g_iFrameLength*iPixelSize;
    frameSize.y = 16*iPixelSize;

    return frameSize;

  }

  // returns width and height of the drawn frame
  public Point2D drawFrame(int iFrame, int iDrawX, int iDrawY, int iPixelSize)
  {

    return drawFrame(g_DataManager.getFrame(g_SelectionInfo.getInstrument(), iFrame), iDrawX, iDrawY, iPixelSize);

  }
  
  
  public Point2D drawFrame(Frame f, int iDrawX, int iDrawY, int iPixelSize)
  {

    Point2D frameSize = getFrameSize(iPixelSize);

    fill(53);
    stroke(153);
    rect(iDrawX, iDrawY, frameSize.x, frameSize.y);
    
    noStroke();

    for (int i = 0; i < g_iFrameLength; i++)
    {
      int iValue = f.getData(i) + 1;

      int iXPos = iDrawX + (i * iPixelSize);

      int iYPos = iDrawY + (16 * iPixelSize) - (iValue * iPixelSize);

      fill(143);
      rect(iXPos, iYPos, iPixelSize, iValue*iPixelSize);   

      fill(243);
      rect(iXPos, iYPos, iPixelSize, iPixelSize);
    }

    return frameSize;

  }
  

  public Point2D getPointInGrid(int x, int y, int iPixelSize)
  {
    Point2D p = new Point2D();
    p.x = x;
    p.y = y;
    return getPointInGrid(p, iPixelSize);
  }


  public Point2D getPointInGrid(Point2D p, int iPixelSize)
  {

    Point2D rtn = new Point2D();

    rtn.x = floor(p.x/iPixelSize);
    rtn.y = floor(p.y/iPixelSize) + 1;

    return rtn;

  }



}

public void generateFrames()
{
  
  g_SawFrame = generateSawFrame();
  
  g_SquareFrame = generateSquareFrame();
  
}


public Frame generateSawFrame()
{
  
  Frame f = new Frame();
  
  for (int i=0; i<g_iFrameLength; i++)
  {
  
    int iValue = 15 - floor(i/2);
    
    f.iData[i] = iValue;
    
  }
  
  return f;
  
}


public Frame generateSquareFrame()
{
  
  return generatePulseWidth(50);
  
}


public Frame generatePulseWidth(int iPercent)
{
  
  Frame f = new Frame();
  
  for (int i=0; i<g_iFrameLength; i++)
  {
    
    float fPercent = (iPercent/100.0f);
    
    int iWidth = floor(g_iFrameLength * fPercent);
    
    println(iWidth);
    
    if (i < iWidth)
    {
      f.iData[i] = 15;
    }
    else
    {
      f.iData[i] = 0;
    }
    
  }
  
  return f;
  
}

  static public void main(String args[]) {     PApplet.main(new String[] { "LSDJ_Wav_Editor_2" });  }}